
#include "bar.h"

std::unordered_map<std::string, CBar2D*> CBar2D::umapBar2D;

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::Init(void)
{
	for (int i = 0; i < 3; i++)
	{
		if (m_pBar[i] == nullptr)continue;
		m_pBar[i]->Init();
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// I
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::Uninit(void)
{
	for (int i = 0; i < 3; i++)
	{
		if(m_pBar[i] == nullptr)continue;
		m_pBar[i]->Uninit();
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::Update(void)
{
	for (int i = 0; i < 3; i++)
	{
		if (m_pBar[i] == nullptr)continue;
		m_pBar[i]->Update();
	}

	// Ԃɂo[̒Ǐ]
	followingBar();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// ԃo[̏
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::followingBar()
{
	D3DXVECTOR3 folSize = m_pBar[1]->GetSize();		// ԃo[TCY
	D3DXVECTOR3 hpBarSize = m_pBar[2]->GetSize();	// HPo[TCY

	if (folSize.x <= hpBarSize.x)
	{
		// TCYƍWv鏈
		m_pBar[1]->SetSize(hpBarSize);
		m_pBar[1]->SetPos(m_pBar[2]->GetPos());
		return;
	}

	// TCYƍWv鏈
	if (folSize.x - 0.5f < hpBarSize.x)
	{
		m_pBar[1]->SetSize(hpBarSize);
		m_pBar[1]->SetPos(m_pBar[2]->GetPos());
	}
	else if(folSize.x > hpBarSize.x)
	{// ԃo[
		m_pBar[1]->AddSize(D3DXVECTOR3(-0.5f, 0.f, 0.f));
		m_pBar[1]->AddPos(D3DXVECTOR3(-0.5f, 0.f, 0.f));
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// `
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::Draw(void)
{
	for (int i = 0; i < 3; i++)
	{
		if (m_pBar[i] == nullptr)continue;
		m_pBar[i]->Draw();
	}
}

// ======== ======== ======== ======== ======== ======== ======== ========
// So[XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::UpdateAll(void)
{
	for (auto bar2D : umapBar2D) { bar2D.second->Update(); }
}

// ======== ======== ======== ======== ======== ======== ======== ========
// So[`
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::DrawAll(void)
{
	for (auto bar2D : umapBar2D) { bar2D.second->Draw(); }
}

// ======== ======== ======== ======== ======== ======== ======== ========
// So[
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::ReleaseAll(void)
{
	for (auto bar2D : umapBar2D) 
	{
		if (bar2D.second != nullptr)
		{
			// 
			bar2D.second->Uninit();
			delete bar2D.second;
			bar2D.second = nullptr;
		}
	}
	// Reiɂ
	umapBar2D.clear();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
CBar2D* CBar2D::Create(D3DXVECTOR2 pos, D3DXVECTOR2 size, int r, int g, int b, int a, float maxVal, std::string strName, int priority)
{
	assert(umapBar2D.count(strName) == 0 && "umapBar2DɊɓ̃pX݂܂");

	CBar2D *pBar2D = new CBar2D;

	pBar2D->m_maxVal = maxVal;
	pBar2D->m_basePos = D3DXVECTOR3(pos.x, pos.y, 0.f);
	pBar2D->m_strName = strName;

	for (int i = 0; i < 3; i++)
	{
		pBar2D->m_pBar[i] = new CScene2D(priority);
		pBar2D->m_pBar[i]->Init();
		pBar2D->m_pBar[i]->SetSize(D3DXVECTOR3(size.x, size.y, 0.f));
		pBar2D->m_pBar[i]->SetPos(D3DXVECTOR3(pos.x, pos.y, 0.f));
		pBar2D->m_pBar[i]->CreateVtxBuffer();
	}
	pBar2D->m_pBar[0]->SetSize(D3DXVECTOR3(size.x + 2, size.y + 2, 0.f));
	pBar2D->m_pBar[0]->SetCol(int(r * 0.01f), int(g * 0.01f), int(b * 0.01f), a);
	pBar2D->m_pBar[1]->SetCol(int(r * 0.5f), int(g * 0.5f), int(b * 0.5f), a);
	pBar2D->m_pBar[2]->SetCol(r, g, b, a);

	umapBar2D[strName] = pBar2D;

	return umapBar2D[strName];
}

// ======== ======== ======== ======== ======== ======== ======== ========
// o[̒l̑ݒ
// -------- -------- -------- -------- -------- -------- -------- --------
void CBar2D::AddVal(float addVal, std::string strName)
{
	if (umapBar2D.count(strName) == 0)return;
	CBar2D* pBar2D = umapBar2D[strName];

	D3DXVECTOR3 maxSize = pBar2D->m_pBar[0]->GetSize();
	D3DXVECTOR3 size = pBar2D->m_pBar[2]->GetSize();

	// Ńo[̑̕Zo
	float val = addVal * maxSize.x / pBar2D->m_maxVal;
	
	if (size.x + val >= maxSize.x)
	{// ^ꍇ͍őTCYɍ킹
		pBar2D->m_pBar[1]->SetSize(maxSize);
		pBar2D->m_pBar[1]->SetPos(pBar2D->m_basePos);
		pBar2D->m_pBar[2]->SetSize(maxSize);
		pBar2D->m_pBar[2]->SetPos(pBar2D->m_basePos);
	}
	else if (size.x + val <= 0.f)
	{// 0ȉꍇ0
		pBar2D->m_pBar[1]->SetSize(D3DXVECTOR3(0.f, maxSize.y, 0.f));
		pBar2D->m_pBar[1]->SetPos(D3DXVECTOR3(pBar2D->m_basePos.x, 0.f, 0.f));
		pBar2D->m_pBar[2]->SetSize(D3DXVECTOR3(0.f, maxSize.y, 0.f));
		pBar2D->m_pBar[2]->SetPos(D3DXVECTOR3(pBar2D->m_basePos.x, 0.f, 0.f));
	}
	else
	{
		pBar2D->m_pBar[2]->AddSize(D3DXVECTOR3(val, 0.f, 0.f));
		pBar2D->m_pBar[2]->AddPos(D3DXVECTOR3(val * 1.f, 0.f, 0.f));
	}
}
